<?php
/*
Plugin Name: TourTask WP
Description: Integrate TourTask seamlessly with your WordPress site. Let your customers book and pay for activities that you have created in your TourTask panel.
Version: 1.0.6
Author: TourTask
Author URI: https://tourtask.com/
License: GPL2
Text Domain: tourtask-wp
Domain Path: /languages
*/

define('TOURTASK_WP_VERSION', '1.0.6');

require_once plugin_dir_path(__FILE__) . 'admin-menu.php'; // Include the admin menu functions
require_once plugin_dir_path(__FILE__) . 'page-settings.php'; // Include the main page functions
require_once plugin_dir_path(__FILE__) . 'page-shortcode.php'; // Include the page functions
require_once plugin_dir_path(__FILE__) . 'shortcode-handler.php';
require_once plugin_dir_path(__FILE__) . 'utils.php'; // Include utility functions

function tourtask_wp_enqueue_react_app() {
	static $enqueued = false;

	if ($enqueued) {
		return;
	}

	$enqueued = true;

	$jsPath = 'https://tourtask-booking.pages.dev/static/js/main.js';
	$cssPath = 'https://tourtask-booking.pages.dev/static/css/main.css';

	// Enqueue the latest files
	wp_enqueue_script('tourtask-wp-react-app-js', $jsPath, array(), TOURTASK_WP_VERSION, true);
	wp_enqueue_style('tourtask-wp-react-app-css', $cssPath, array(), TOURTASK_WP_VERSION);

	wp_enqueue_style('tourtask-wp-general-css', plugins_url('/tourtask-wp/css/general.css'), array(), TOURTASK_WP_VERSION);
}


function tourtask_wp_full_width_css() {
	if (get_option('tourtask_wp_force_full_width')) { //Force full width
		$currentTheme = wp_get_theme();
		$currentThemeCode = $currentTheme->get_stylesheet();
		$theme_css_path = plugin_dir_path(__FILE__) . 'css/force-full-width/' . $currentThemeCode . '.css';

		if (file_exists($theme_css_path)) {
			wp_enqueue_style('tourtask-wp-full-width-css-theme', plugins_url('/css/force-full-width/' . $currentThemeCode . '.css', __FILE__), array(), TOURTASK_WP_VERSION);
		} else {
			wp_enqueue_style('tourtask-wp-full-width-css', plugins_url('/css/force-full-width/_general.css', __FILE__), array(), TOURTASK_WP_VERSION);
		}
	}
}
add_action('wp_enqueue_scripts', 'tourtask_wp_full_width_css');

function tourtask_wp_load_textdomain() {
	load_plugin_textdomain('tourtask-wp', false, dirname(plugin_basename(__FILE__)) . '/languages');
}
add_action('init', 'tourtask_wp_load_textdomain');

// Activation hook to set default options
function tourtask_wp_activate() {
	add_option('tourtask_wp_force_full_width', '1');
	add_option('tourtask_wp_header_type', 'id');
	add_option('tourtask_wp_mobile_header_type', 'id');
	add_option('tourtask_wp_mobile_header_until_width', '1024');
}
register_activation_hook(__FILE__, 'tourtask_wp_activate');
?>