<?php
function tourtask_wp_shortcode_handler($atts) {
	$atts = shortcode_atts(
		array(
			'page' => 'default',
			'lang' => 'en'
		),
		$atts,
		'tourtask-wp'
	);

	// Get WordPress option values
	$businessAbbreviation = get_option('tourtask_wp_business_abbreviation');
	$businessToken = get_option('tourtask_wp_business_token');
	$useCustomHeader = get_option('tourtask_wp_use_custom_header') === '1' ? true : false;
	$useCustomMobileHeader = get_option('tourtask_wp_use_mobile_header') === '1' ? true : false;

	if ($useCustomHeader) {
		$headerName = get_option('tourtask_wp_header_name');
		$headerType = get_option('tourtask_wp_header_type');
		$headerIsSticky = get_option('tourtask_wp_header_is_sticky') === '1' ? true : false;

		if ($useCustomMobileHeader) {
			$mobileHeaderName = get_option('tourtask_wp_mobile_header_name');
			$mobileHeaderType = get_option('tourtask_wp_mobile_header_type');
			$mobileHeaderIsSticky = get_option('tourtask_wp_mobile_header_is_sticky') === '1' ? true : false;
			$mobileHeaderUntilWidth = get_option('tourtask_wp_mobile_header_until_width');
		}
	}

	if (empty($businessAbbreviation) || empty($businessToken)) {
		return '<div class="padding-40"><div class="tourtask-wp-error">' . esc_html__('Business Abbreviation and Business Token are required.', 'tourtask-wp') . ' ' . sprintf(
			wp_kses(
				// Translators: %s is the URL to the settings page.
				__('Go to <a href="%s">Settings</a> to set them up.', 'tourtask-wp'),
				array(
					'a' => array(
						'href' => array()
					)
				)
			),
			esc_url(admin_url('admin.php?page=tourtask-wp'))
		) . '</div></div>';
	}

	if (empty($atts['lang'])) {
		$atts['lang'] = 'en';
	}

	if (empty($atts['page'])) {
		$atts['page'] = 'activities';
	}

	// Ensure the script and styles are enqueued
	tourtask_wp_enqueue_react_app();
	
	$currentTheme = wp_get_theme();
	$currentThemeSlug = $currentTheme->get_stylesheet();

	// Return the mounting point for the React app
	return '
	<div
		id="tourtask-booking-root"
		data-page="' . esc_attr($atts['page']) . '"
		data-lang="' . esc_attr($atts['lang']) . '"
		data-business-slug="' . esc_attr($businessAbbreviation) . '"
		data-business-token="' . esc_attr($businessToken) . '"
		data-is-embedded="true"
		data-cms-slug="wordpress"
		data-cms-theme-slug="' . esc_attr($currentThemeSlug) . '"
		data-cms-theme-version="' . esc_attr($currentTheme->get('Version')) . '"' . 
		($useCustomHeader ? 
			'
				data-header-name="' . esc_attr($headerName) . '"
				data-header-type="' . esc_attr($headerType) . '"
				data-header-is-sticky="' . ($headerIsSticky ? 'true' : 'false') . '"
			' : ''
		) . 
		($useCustomHeader && $useCustomMobileHeader ? 
			'
				data-mobile-header-name="' . esc_attr($mobileHeaderName) . '"
				data-mobile-header-type="' . esc_attr($mobileHeaderType) . '"
				data-mobile-header-is-sticky="' . ($mobileHeaderIsSticky ? 'true' : 'false') . '"
				data-mobile-header-until-width="' . esc_attr($mobileHeaderUntilWidth) . '"
			' : ''
		) .
	'></div>';
}

add_shortcode('tourtask-wp', 'tourtask_wp_shortcode_handler');
?>