<?php
function tourtask_wp_shortcode() {
	$ttLangOptions = array(
		'en' => 'English',
		'es' => 'Spanish'
	);

	$defaultLangCode = 'en';
    $userLangCode = substr(get_user_locale(), 0, 2);

	$preselectedLangCode = $defaultLangCode;

	// Check if the user's language is in the list of supported languages
	foreach ($ttLangOptions as $ttLangOptionCode => $ttLangOptionString) {
		if ($userLangCode == $ttLangOptionCode) {
			$preselectedLangCode = $userLangCode;
			break;
		}

	}
	
    $user_locale = substr(get_user_locale(), 0, 2);
    $default_lang = ($user_locale == 'es') ? 'es' : 'en';
	
    ?>
    <div class="wrap">
        <h1><?php esc_html_e('Shortcode', 'tourtask-wp'); ?></h1>

        <!-- Instructions -->
        <div class="instructions">
            <p><?php esc_html_e('To use the TourTask WP shortcode, copy and paste the following code into the page where you want the booking system to appear.', 'tourtask-wp'); ?></p>
        </div>

        <!-- Language Selector -->
        <label for="shortcode-lang" style="margin-right: 20px;"><?php esc_html_e('Select Language', 'tourtask-wp'); ?></label>

        <select id="shortcode-lang">
			<?php

			// Language Selector
			foreach ($ttLangOptions as $ttLangOptionCode => $ttLangOptionString) {
				$selected = $ttLangOptionCode == $preselectedLangCode ? 'selected' : '';
				echo '<option value="' . esc_attr($ttLangOptionCode) . '" ' . esc_attr($selected) . '>' . esc_html($ttLangOptionString) . '</option>';
			}
			?>
			</select>

        <!-- Shortcode Display -->
        <p>
            <code id="shortcode-display">[tourtask-wp page="activities" lang="<?php echo esc_attr($preselectedLangCode); ?>"]</code>
            <button id="copy-shortcode" class="button" style="margin-left: 20px;"><?php esc_html_e('Copy Shortcode', 'tourtask-wp'); ?></button>
		</p>
    </div>
    <?php
}
?>