<?php
// Add main menu with a placeholder icon
function tourtask_wp_add_menu_page() {
	add_menu_page(
		__('TourTask WP Settings', 'tourtask-wp'),				// Page title
		'TourTask WP',											// Menu title
		'manage_options',										// Capability
		'tourtask-wp',											// Menu slug
		'tourtask_wp_settings',									// Callback function
		plugins_url('images/tourtask-menu-icon.png', __FILE__),	// Placeholder icon (will be hidden)
		6														// Position
	);

	// Submenu: Rename first item (e.g., Settings)
	add_submenu_page(
		'tourtask-wp',									// Parent slug
		__('TourTask WP Settings', 'tourtask-wp'),		// Page title
		__('Settings', 'tourtask-wp'),					// Menu title
		'manage_options',								// Capability
		'tourtask-wp',									// Menu slug (same as main menu)
		'tourtask_wp_settings'							// Callback function (same as main menu)
	);

	// Submenu: Shortcode Page
	add_submenu_page(
		'tourtask-wp',								// Parent slug
		__('TourTask WP Shortcode', 'tourtask-wp'),	// Page title
		__('Shortcode', 'tourtask-wp'),				// Menu title
		'manage_options',							// Capability
		'tourtask-wp-shortcode',					// Menu slug
		'tourtask_wp_shortcode'						// Callback function
	);

	// Add inline CSS for the custom icon hover effect
	/* add_action('admin_head', 'tourtask_wp_custom_admin_css'); */
}
add_action('admin_menu', 'tourtask_wp_add_menu_page');

/* function tourtask_wp_custom_admin_css() {
	echo '<style>
		#toplevel_page_tourtask-wp .wp-menu-image img {
			content: url("' . plugins_url('images/tourtask-menu-icon.png', __FILE__) . '");
		}
		#toplevel_page_tourtask-wp:hover .wp-menu-image img,
		#toplevel_page_tourtask-wp.wp-has-current-submenu .wp-menu-image img {
			content: url("' . plugins_url('images/tourtask-menu-icon-hover.png', __FILE__) . '");
		}
	</style>';
} */

function tourtask_wp_register_settings() {
	register_setting('tourtask_wp_options_group', 'tourtask_wp_business_abbreviation', 'tourtask_wp_validate_input');
	register_setting('tourtask_wp_options_group', 'tourtask_wp_business_token', 'tourtask_wp_validate_input');
	register_setting('tourtask_wp_options_group', 'tourtask_wp_force_full_width');
	register_setting('tourtask_wp_options_group', 'tourtask_wp_use_custom_header');
	register_setting('tourtask_wp_options_group', 'tourtask_wp_header_name');
	register_setting('tourtask_wp_options_group', 'tourtask_wp_header_type');
	register_setting('tourtask_wp_options_group', 'tourtask_wp_header_is_sticky');
	register_setting('tourtask_wp_options_group', 'tourtask_wp_use_mobile_header');
	register_setting('tourtask_wp_options_group', 'tourtask_wp_mobile_header_name');
	register_setting('tourtask_wp_options_group', 'tourtask_wp_mobile_header_type');
	register_setting('tourtask_wp_options_group', 'tourtask_wp_mobile_header_is_sticky');
	register_setting('tourtask_wp_options_group', 'tourtask_wp_mobile_header_until_width');
}
add_action('admin_init', 'tourtask_wp_register_settings');

function tourtask_wp_admin_scripts() {
	// Enqueue custom script
	wp_enqueue_script(
		'tourtask-wp-admin-js',
		plugins_url('/js/admin.js', __FILE__),
		array('jquery'),
		TOURTASK_WP_VERSION,
		true
	);

	// Localize script to use AJAX URL in the custom script
	wp_localize_script(
		'tourtask-wp-admin-js',
		'tourtaskWP',
		array(
			'ajax_url' => admin_url('admin-ajax.php'),
			'messages' => array(
				'settingsSaved' => esc_html__('Settings saved successfully.', 'tourtask-wp'),
				'settingsSaveError' => esc_html__('An error occurred while saving settings.', 'tourtask-wp'),
				'messageSentRespondSoon' => esc_html__('Message sent successfully. We will respond to you shortly.', 'tourtask-wp'),
				'messageSendError' => esc_html__('An error occurred while sending information.', 'tourtask-wp'),
				'shortcodeCopiedToClipboard' => esc_html__('Shortcode copied to clipboard.', 'tourtask-wp'),
				'shortcodeCopyToClipboardError' => esc_html__('Could not copy shortcode to clipboard.', 'tourtask-wp')
			)
		)
	);

	// Enqueue admin CSS
	wp_enqueue_style(
		'tourtask-wp-admin-css',
		plugins_url('/css/admin.css', __FILE__),
		array(),
		TOURTASK_WP_VERSION
	);

}
add_action('admin_enqueue_scripts', 'tourtask_wp_admin_scripts');

function tourtask_wp_save_settings() {
	$formData = $_POST['data'];
	
	// Check for nonce
	if (!isset($formData['tourtask_wp_options_group_nonce']) || !wp_verify_nonce($formData['tourtask_wp_options_group_nonce'], 'tourtask_wp_options_group')) {
		wp_send_json_error('Invalid nonce');
		return; // Exit the function if nonce is invalid
	}

	// Save settings
	foreach ($formData as $key => $value) {
		update_option($key, sanitize_text_field($value));
	}
	
	wp_send_json_success();
}
add_action('wp_ajax_tourtask_wp_save_settings', 'tourtask_wp_save_settings');

function tourtask_wp_validate_input($input) {
	if (empty($input)) {
		add_settings_error('tourtask_wp_options_group', 'tourtask_wp_error', 'Please fill out this field.', 'error');
		return ''; // Return empty to highlight not configured
	}
	return sanitize_text_field($input);
}

function tourtask_wp_admin_notices() {
	if (empty(get_option('tourtask_wp_business_abbreviation')) || empty(get_option('tourtask_wp_business_token'))) {
		echo '<div class="notice notice-warning is-dismissible">
			<p><strong>TourTask WP:</strong> ' . esc_html__('Please configure Business Abbreviation and Business Token for the plugin to function properly.', 'tourtask-wp') . '</p>
		</div>';
	}
}
add_action('admin_notices', 'tourtask_wp_admin_notices');

// Custom CSS for admin area...
?>
